@extends('layouts.app')

@section('content')





<section class="right-sidebar" id="sidebarRight">
    <div class="view-release-sec">
        <div class="view-release">
            <div class="view-release-heading">
                <h6>View DSP</h6>
            </div>

            @can(['create-dsp'])
            <div class="view-all-release-search">
                <a href="{{ route('dsp.create') }}"><button class="btn vewReleaseBtn"><i class="fa-solid fa-plus"></i>Add New</button></a>
            </div>
            @endcan


        </div>

        <div class="viewReleases-main-sec">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>DSP Name</th>
                        <th>DSP Status</th>
                        <th width="280px">Action</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($data as $key => $dsp)
                    <tr>
                        <td>{{ ++$i }}</td>
                        <td>{{ $dsp->name }}</td>

                        <td>
                            @can(['edit-dsp'])
                            <input type="checkbox" id="dsp_{{ $dsp->id }}" class="form-check-input dspStatus" name="dspStatus" @if($dsp->status==1) checked @endif />
                            @endcan

                            @if(!empty($dsp->status))
                            <label id="dspStatus_{{ $dsp->id }}" class="badge bg-success">Active</label>
                            @else
                            <label id="dspStatus_{{ $dsp->id }}" class="badge bg-danger">Disabled</label>
                            @endif
                        </td>

                        <td>

                            @can(['edit-dsp'])
                            <a class="btn btn-primary btn-sm" href="{{ route('dsp.edit',$dsp->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
                            @endcan

                            @can(['delete-dsp'])
                            <form method="POST" action="{{ route('dsp.destroy', $dsp->id) }}" style="display:inline">
                                @csrf
                                @method('DELETE')
                                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
                            </form>
                            @endcan

                        </td>
                    </tr>
                    @endforeach

                </tbody>
            </table>
            {!! $data->links('pagination::bootstrap-5') !!}

        </div>
    </div>
</section>



<script>
    $(document).ready(function() {
        $(".dspStatus").change(function() {

            var dspStr = $(this).attr('id');
            var dspArr = dspStr.split("_");
            var dspId = dspArr[1];

            $.ajax({
                url: "{{route('dsp.status.update')}}",
                type: "POST",
                data: {
                    dspId: dspId,
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(requestResponse) {

                    var dspStatusId = "dspStatus_" + dspId;

                    if (requestResponse == "disabledDSP") {
                        $(this).prop('checked', false);
                        $("#" + dspStatusId).removeClass("bg-success");
                        $("#" + dspStatusId).addClass("bg-danger");
                        $("#" + dspStatusId).text("Disabled");
                    } else if (requestResponse == "activeDSP") {
                        $(this).prop('checked', true);
                        $("#" + dspStatusId).addClass("bg-success");
                        $("#" + dspStatusId).removeClass("bg-danger");
                        $("#" + dspStatusId).text("Active");
                    }
                },

                error: function(response) {
                    alert('Something went wrong!');
                    console.log(response);
                    return false;
                }

            });

        });


    });
</script>





{{--
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>DSP Management</h2>
        </div>

        <div class="pull-right">
            <a class="btn btn-success mb-2" href="{{ route('dsp.create') }}"><i class="fa fa-plus"></i> Create New DSP</a>
</div>

</div>
</div>

@session('success')
<div class="alert alert-success" role="alert">
    {{ $value }}
</div>
@endsession

<table class="table table-bordered">
    <tr>
        <th>No</th>
        <th>DSP Name</th>
        <th>DSP Status</th>
        <th width="280px">Action</th>
    </tr>
    @foreach ($data as $key => $dsp)
    <tr>
        <td>{{ ++$i }}</td>
        <td>{{ $dsp->name }}</td>

        <td>
            <input type="checkbox" id="dsp_{{ $dsp->id }}" class="form-check-input dspStatus" name="dspStatus" @if($dsp->status==1) checked @endif />

            @if(!empty($dsp->status))
            <label id="dspStatus_{{ $dsp->id }}" class="badge bg-success">Active</label>
            @else
            <label id="dspStatus_{{ $dsp->id }}" class="badge bg-danger">Disabled</label>
            @endif
        </td>

        <td>
            <a class="btn btn-primary btn-sm" href="{{ route('dsp.edit',$dsp->id) }}"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
            <form method="POST" action="{{ route('dsp.destroy', $dsp->id) }}" style="display:inline">
                @csrf
                @method('DELETE')
                <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
            </form>
        </td>
    </tr>
    @endforeach
</table>

{!! $data->links('pagination::bootstrap-5') !!}



<script>
    $(document).ready(function() {
        $(".dspStatus").change(function() {

            var dspStr = $(this).attr('id');
            var dspArr = dspStr.split("_");
            var dspId = dspArr[1];

            $.ajax({
                url: "{{route('dsp.status.update')}}",
                type: "POST",
                data: {
                    dspId: dspId,
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(requestResponse) {

                    var dspStatusId = "dspStatus_" + dspId;

                    if (requestResponse == "disabledDSP") {
                        $(this).prop('checked', false);
                        $("#" + dspStatusId).removeClass("bg-success");
                        $("#" + dspStatusId).addClass("bg-danger");
                        $("#" + dspStatusId).text("Disabled");
                    } else if (requestResponse == "activeDSP") {
                        $(this).prop('checked', true);
                        $("#" + dspStatusId).addClass("bg-success");
                        $("#" + dspStatusId).removeClass("bg-danger");
                        $("#" + dspStatusId).text("Active");
                    }
                },

                error: function(response) {
                    alert('Something went wrong!');
                    console.log(response);
                    return false;
                }

            });

        });
    });
</script>--}}

@endsection